#include <stdio.h>
#include <string.h>

FILE *outfile;
struct FILE_HEADER {
	unsigned char riff[4];
	unsigned long size;
	unsigned char wave[4];
};

struct FORMAT_HEADER {
	unsigned char format[4];
	unsigned long size;
	short         compression_type;
	short         channels;
	unsigned long sample_rate;
	unsigned long bytes_per_second;
	short         block_alignment;
	short         bits_per_sample;
};

#define _3_second

#ifdef _3_second
#define FILE_SIZE 288000
#endif

#ifdef _30_second
#define FILE_SIZE 2880000
#endif

#ifdef _300_second
#define FILE_SIZE 28800000
#endif

#if 1

struct FILE_HEADER file_header = {"RIFF", 
                                   0, 
                                   "WAVE"};
struct FORMAT_HEADER format_header=
                       {"fmt ",    /* chunk ID string */
                        16,        /* Chunk data size */
                        1,         /* Compression type*/
                        2,         /* Number of audio channels */
                        44100,     /* 44100 kHz sample rate */
                        176400,    /* Average bytes per second (96000) */
                        4,         /* Block align 2 bytes per sample for both channels */
                        16         /* 8 bits per sample */
                                   /* no extra format bytes */
                        };
#else

struct FILE_HEADER file_header = {"RIFF", 
                                   0, 
                                   "WAVE"};
struct FORMAT_HEADER format_header = {"fmt ",
                                      16,
                                      1,
                                      2,
                                      48000,
                                      192000,
                                      4,
                                      16};
#endif

signed short cosine_table[12] = { 32767, 28377, 16384,     0,-16384,-28377,
                                 -32767,-28377,-16384,     0, 16384, 28377};
signed short sine_table[12]   = {    0, 16384, 28377, 32767, 28377, 16384,
                                     0,-16384,-28377,-32767,-28377,-16384};
unsigned long file_size, sample_rate, bytes_per_second;

signed short zero_to_one_wave[24] =
    { 32767, 0, 28377, 0, 16384, 0,    0,  0,-16384, 0,-28377, 0,
    -32767, 0,-28377, 0,-16384, 0,    0,  0, 16384, 0, 28377, 0};

signed short one_to_zero_wave[24] =
    { 32767, 0, 28377, 0, 16384, 0,    0,  0,-16384, 0,-28377, 0,
    -32767, 0,-28377, 0,-16384, 0,    0,  0, 16384, 0, 28377, 0};

signed short zero[24] =
    { 32767,-23173, 28377,-31656, 16384,-31656,0,-23173,-16384, -8482,-28377, 8482,
     -32767, 23173,-28377, 31656,-16384, 31656,0, 23173, 16384,  8482, 28377,-8482};

signed short one[24] =
    { 32767, 23173, 28377, 31656, 16384, 31656,0, 23173,-16384,  8482,-28377,-8482,
    -32767,-23173,-28377,-31656,-16384,-31656,0,-23173, 16384, -8482, 28377, 8482};

signed short leader[30] = {     0, 0, 16384, 0, 28377, 0, 
                            32767, 0, 28377, 0, 16384, 0,
                                0, 0,-16384, 0,-28377, 0,
                           -32767, 0,-28377, 0,-16384, 0,
                                0, 0, 16384, 0, 28377, 0};
signed short trailer[32] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

void write_zero(void)
{
    fwrite(zero, 48, 1, outfile);
    fwrite(zero, 48, 1, outfile);
    fwrite(zero, 48, 1, outfile);
    fwrite(zero, 48, 1, outfile);
    fwrite(zero, 48, 1, outfile);
    fwrite(zero, 48, 1, outfile);
    fwrite(zero, 48, 1, outfile);
    fwrite(zero, 48, 1, outfile);
}

void write_one(void)
{
    fwrite(one, 48, 1, outfile);
    fwrite(one, 48, 1, outfile);
    fwrite(one, 48, 1, outfile);
    fwrite(one, 48, 1, outfile);
    fwrite(one, 48, 1, outfile);
    fwrite(one, 48, 1, outfile);
    fwrite(one, 48, 1, outfile);
    fwrite(one, 48, 1, outfile);
}

void write_one_to_zero(void)
{
    fwrite(one_to_zero_wave, 48, 1, outfile);
    fwrite(one_to_zero_wave, 48, 1, outfile);
}

void write_zero_to_one(void)
{
    fwrite(zero_to_one_wave, 48, 1, outfile);
    fwrite(zero_to_one_wave, 48, 1, outfile);
}

int main(void)
{
unsigned long i = 0;

    outfile = fopen("c:/iq_straight.wav", "wb");
    file_header.size = FILE_SIZE + 0x24;
    /* write the 12 bytes of the file header */
    fwrite(&file_header, 12, 1, outfile);
    /* write the format header */
    fwrite(&format_header, 24, 1, outfile);
	fwrite("data", 4, 1, outfile);
    file_size = FILE_SIZE;
    fwrite(&file_size, 4,1, outfile);
    fwrite(leader, 60, 1, outfile);
    while (i < file_size-(96+384+92+384+10))
    {
        write_zero_to_one();
        i += 96;
        write_one();
        i += 384;
        write_one_to_zero();
        i += 96;
        write_zero();
        i += 384;
    }

    while (i < file_size)
    {
        fputc(0, outfile);
        i++;
    }
	fclose(outfile);
/*    outfile = fopen("c:/iq_straight.txt", "wt");
    for (i = 0; i< 24; )
    {
        fprintf(outfile,"%6.6d %6.6d\n", zero[i], zero[i+1]);
        i += 2;
    }
    for (i = 0; i< 24; )
    {
        fprintf(outfile,"%6.6d %6.6d\n", one[i], one[i+1]);
        i += 2;
    }
*/
	return 0;
}
